
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Jul 22 10:17:10 2007
   *  Last modified   :  %modify_time%
   */
  /** @file 
   *  \brief A brief description of this module 
   *
   *  \version KMNG_ATP_TST_ManageOp_Data.c#1:csrc:1
   *  \author NogaD
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ****************/
#include "KMNG_ATP_TST_ManageOp.h"
#include "KMNG_ATP_TST_KeysOp.h"


/************************ Defines *******************************/

/* canceling the lint warning:
   Too few initializers for aggregate 'unknown-name' */
/*lint --e{785} */

/************************ Enums *********************************/
/************************ Typedefs ******************************/
/************************ Global Data ***************************/

/* Data struct for test KMNG_ATP_TST_Key_Ring_Management */
TST_RingManage_TestDataStruct TST_RingManage_TestData[] = 
{
  {
    {"Acceptance test - Key Ring Management Operations 1 key"},
    /*TST_Pwd*/
    {0x0a,0x0a,0x0b,0x0b,0x0c,0x0c,0x0d,0x0d,0x0f,0x0f},
    /*TST_PwdLen*/
    10,
    /*TST_NumSymKeys*/
    1,
    /*TST_NumRSAKeys*/
    1,
    /*TST_NumDHKeys*/
    1
  },
  {
    {"Acceptance test - Key Ring Management Operations 3 keys"},
    /*TST_Pwd*/
    {0x0a,0x0b,0x01,0x02,0x03,0x04,0x05,0x06},
    /*TST_PwdLen*/
    8,
    /*TST_NumSymKeys*/
    3,
    /*TST_NumRSAKeys*/
    3,
    /*TST_NumDHKeys*/
    3
  },
  {
    {"Acceptance test - Key Ring Management Operations 5 keys"},
    /*TST_Pwd*/
    {0x0a,0x0b,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09},
    /*TST_PwdLen*/
    11,
    /*TST_NumSymKeys*/
    5,
    /*TST_NumRSAKeys*/
    5,
    /*TST_NumDHKeys*/
    5
  }    
        
};

/* Data structures for the KMNG List test*/
TST_RingListSym_TestDataStruct TST_RingListSym_TestData[] = 
{
  {
	{"AES128 key"},
    /*TST_KeyPwd*/
    {0x01,0x02,0x03,0x04,0x05,0x06,0x0a,0x0b},
    /*TST_KeyPwdLen*/
    8,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage - not used*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction - not used*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08},
    /*TST_KeySize*/
    16,
    {0}
  },
  {
    {"HMAC-SHA1 key"},
    /*TST_KeyPwd*/
    {0x01,0x02,0x03,0x04,0x05,0x06,0x0a,0x0a},
    /*TST_KeyPwdLen*/
    8,
    /*TST_KeyType*/
    KMNG_KeyTypeHMAC,
    /*TST_KeyUsage - not used*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction - not used*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,
     0x01,0x02,0x03,0x04},
     /*TST_KeySize*/
     20,
    {0}
  },
  {
    {"HMAC-SHA1 key"},
    /*TST_KeyPwd*/
    {0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a},
    /*TST_KeyPwdLen*/
    10,
    /*TST_KeyType*/
    KMNG_KeyTypeHMAC,
    /*TST_KeyUsage - not used*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction - not used*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,
     0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08},
     /*TST_KeySize*/
     32,
    {0}
  }
};


TST_RingListRSA_TestDataStruct TST_RingListRSA_TestData[] = 
{
  {
    {"RSA2048 key"},
    /*TST_KeyPwd*/
    {0x01,0x01,0x01,0x01,0x01,0x02,0x02,0x02,0x02,0x02},
    /*TST_KeyPwdLen*/
    10,
    /*TST_KeyType*/
    KMNG_KeyTypeRSAPair,
    /*TST_KeyUsage - not used*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction - not used*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_KeySize*/
    256,
    /*TST_E*/
    {0x01,0x00,0x01},
    /*TST_ESize*/
    3,
    /*TST_ExportedE*/
    {0},
    /*TST_ExportedESize*/
    0,
    /*TST_N*/
    {0xaf,0x6b,0xc3,0x36,0x4e,0x47,0x06,0x66,0xcb,0xee,0xce,0x95,0xcd,0xc2,0x61,0xad,
     0x12,0x3b,0x38,0x74,0x55,0x26,0xa9,0x74,0xf5,0xa2,0x47,0xb9,0x93,0x95,0x32,0xbe,
     0x9a,0xf2,0x14,0xb4,0x85,0xb5,0xcd,0x2a,0x6f,0x9d,0x6d,0x95,0x1a,0x95,0x15,0x58,
     0x24,0x4c,0x6a,0xe8,0x3e,0x2c,0x0e,0xe4,0x80,0x2f,0x4a,0x88,0x02,0xdd,0x99,0xf7,
     0x6b,0xc3,0xa5,0xe6,0x28,0xe3,0x9b,0x11,0xa0,0x47,0x65,0x70,0x27,0xff,0xd2,0x34,
     0xd2,0x19,0x30,0xea,0x81,0x46,0x7a,0xcd,0x0a,0x6a,0x63,0x69,0x7c,0xa2,0x76,0x70,
     0x1f,0x2d,0x09,0x25,0x39,0x42,0x0e,0xa3,0xf2,0x1e,0x50,0xf1,0x29,0x7d,0xad,0x00,
     0xe5,0xb1,0x39,0x05,0x9d,0x64,0xe9,0x17,0xdb,0x9c,0x9a,0x10,0xa3,0x02,0xf6,0xcf,
     0x4c,0x43,0x48,0x74,0xce,0xc0,0xaa,0xc1,0x4d,0xaa,0x19,0x39,0x68,0x9e,0x93,0xf2,
     0x3d,0x77,0xf0,0x39,0x52,0x66,0xaf,0xf6,0x8c,0x8c,0x98,0x88,0x71,0x77,0xd7,0x61,
     0x0e,0xd6,0x3e,0xc7,0x46,0xaa,0x13,0x93,0x68,0x16,0xe5,0x13,0xb8,0xb9,0x8c,0xea,
     0x97,0xd8,0x15,0x0e,0xf1,0xb1,0xb1,0xfc,0x13,0x7b,0x48,0x5b,0xd3,0x84,0x13,0x5f,
     0x47,0xeb,0x90,0x2c,0x80,0x0e,0x8c,0xce,0xa6,0xf3,0x28,0x78,0xfb,0xc5,0xc1,0x02,
     0xf9,0x2e,0x4a,0x72,0x16,0x62,0x68,0xde,0x9f,0x47,0xe9,0xdb,0x53,0x6b,0xd3,0xf9,
     0x84,0x16,0x93,0x96,0x32,0xe7,0x8d,0x19,0x19,0x10,0x6f,0x5e,0x5f,0xe3,0x3e,0x1b,
     0x76,0x1f,0x0c,0x74,0x56,0x46,0x29,0x96,0x9e,0x87,0xd6,0xbc,0x26,0x0e,0xee,0x03},
    /*TST_NSize*/
    256,
    /*TST_ExportedN*/
    {0},
     /*TST_ExportedNSize*/
    0,
     /*TST_D*/
    {0x28,0x8d,0x32,0xcd,0x64,0xff,0x0a,0x3d,0xcd,0x3a,0xe1,0x4a,0xc4,0x0c,0x01,0x64,
     0x6e,0xe8,0x7d,0xbe,0x76,0xc8,0xbf,0x37,0xa8,0x68,0xe1,0x47,0xc7,0x14,0x20,0x6c,
     0xeb,0x88,0xb6,0xbc,0x9c,0x84,0x50,0x6f,0x54,0xea,0x01,0xa1,0x0c,0x4a,0x16,0x6b,
     0x0f,0xc9,0x12,0x95,0xa9,0x79,0xa9,0xdf,0xac,0xba,0x41,0xf2,0x7b,0x27,0x1b,0x26,
     0x95,0x24,0xdf,0x3e,0xfb,0x88,0xd2,0x1a,0x1b,0x01,0x26,0x33,0xed,0x2b,0x38,0x3e,
     0xb9,0xaa,0xd5,0x22,0x00,0xcc,0x78,0x2a,0xda,0x13,0x89,0xf3,0xa2,0xba,0x33,0xc2,
     0xeb,0x92,0x0f,0xa1,0x29,0x41,0x59,0xfd,0x10,0x45,0x6d,0xd4,0xb2,0x10,0xb9,0x63,
     0x91,0xb5,0x8c,0x46,0xfe,0x01,0x8b,0xd8,0xd6,0x0d,0xb7,0x97,0xcc,0xf7,0x2c,0x72,
     0x91,0x42,0xc2,0xae,0x6c,0xdf,0x2c,0x8e,0x47,0x01,0xaa,0x84,0x1d,0xb1,0xa2,0xa4,
     0xc3,0x01,0xf1,0xf2,0xd6,0x17,0x66,0x6a,0x21,0xc1,0x67,0x88,0x99,0x4d,0xf9,0xfa,
     0xd8,0x81,0x84,0x3e,0x8a,0x50,0xb9,0x04,0xad,0xe1,0x16,0xc8,0x7f,0x77,0x8c,0x8a,
     0x69,0x51,0x3b,0x0d,0x07,0x4e,0xcd,0xf2,0xd1,0xb8,0x28,0x08,0xbd,0x4a,0xb0,0x5e,
     0xc4,0xd2,0xe0,0x43,0xe2,0xce,0x93,0xa8,0xaa,0x68,0x97,0x46,0x07,0xd8,0xdc,0xc1,
     0x98,0xa7,0xc6,0x90,0x87,0xc2,0x1b,0x7c,0x97,0xe5,0xe3,0x99,0x20,0xdb,0xe1,0xcf,
     0x08,0x1c,0x50,0xa4,0x1d,0x2f,0xdb,0xfa,0x24,0x6d,0x72,0x68,0xd7,0xe6,0x77,0xca,
     0x19,0x9e,0xa5,0x4f,0x11,0x2d,0x7b,0xce,0x3e,0xb4,0x42,0xa1,0x64,0x92,0xe6,0x31},
    /*TST_DSize*/
    256,
    /*TST_ExportedD*/
    {0},
    /*TST_ExportedDSize*/
    0
  }, 
  {
    {"RSA1024 key"},
    /*TST_KeyPwd*/
    {0x07,0x07,0x04,0x04,0x01,0x02,0x02,0x02,0x02,0x02},
    /*TST_KeyPwdLen*/
    10,
    /*TST_KeyType*/
    KMNG_KeyTypeRSAPair,
    /*TST_KeyUsage - not used*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction - not used*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_KeySize*/
    128,
    /*TST_E*/
    {0x03},
    /*TST_ESize*/
    1,
    /*TST_ExportedE*/
    {0},
     /*TST_ExportedESize*/
    0,
    /*TST_N*/
    {0xb2,0x2b,0x7e,0xbd,0x89,0xe9,0x7d,0xf5,0x53,0x87,0x54,0x88,0x0f,0x1e,0xff,0xe6,
     0x62,0xa2,0x0c,0x4e,0x74,0x6a,0x11,0x19,0x49,0xfe,0x16,0x39,0xe6,0xdc,0x4c,0x26,
     0x2d,0xc8,0x49,0x5f,0xb9,0x76,0x16,0x63,0x6f,0xae,0x07,0xd3,0x8f,0x05,0x50,0xe0,
     0xda,0xb6,0xef,0xf0,0x3e,0xa9,0x8d,0xdc,0xe9,0xf8,0xbe,0x18,0xda,0x39,0x58,0xae,
     0xca,0xe0,0xc8,0x96,0x02,0x0f,0xf6,0x98,0x03,0x86,0xd5,0x25,0xdf,0x4f,0xf2,0x41,
     0x77,0xce,0x44,0x6e,0x5d,0x68,0x00,0xfa,0xe4,0x72,0xa0,0x92,0xa0,0x86,0xa1,0x83,
     0xfd,0xd1,0x29,0x53,0x03,0x00,0x9e,0x56,0xa6,0x1b,0x90,0x46,0xba,0xe4,0x92,0xb6,
     0xba,0xc0,0x65,0xa2,0x95,0x35,0x5d,0xf8,0xf2,0xba,0xde,0x14,0x8f,0x43,0x35,0xa1},
     /*TST_NSize*/
    128,
    /*TST_ExportedN*/
    {0},
    /*TST_ExportedNSize*/
    0,
     /*TST_D*/
    {0x76,0xc7,0xa9,0xd3,0xb1,0x46,0x53,0xf8,0xe2,0x5a,0x38,0x5a,0xb4,0xbf,0x55,0x44,
     0x41,0xc1,0x5d,0x89,0xa2,0xf1,0x60,0xbb,0x86,0xa9,0x64,0x26,0x99,0xe8,0x32,0xc4,
     0x1e,0x85,0x86,0x3f,0xd0,0xf9,0x64,0x42,0x4a,0x74,0x05,0x37,0xb4,0xae,0x35,0xeb,
     0x3c,0x79,0xf5,0x4a,0xd4,0x71,0x09,0x3d,0xf1,0x50,0x7e,0xbb,0x3c,0x26,0x3b,0x1e,
     0x14,0xc3,0xe5,0xad,0x04,0xf9,0x7a,0x8d,0xfc,0x46,0x30,0xd4,0xd9,0x8b,0x11,0x73,
     0xfd,0xfe,0xd6,0x33,0x15,0x73,0x45,0x12,0x35,0xcb,0x7f,0xa4,0x3c,0x34,0x31,0xb7,
     0xa0,0x59,0x46,0x84,0xb3,0x53,0x8d,0x12,0xca,0x7f,0x60,0xd7,0x2e,0x9b,0x52,0x82,
     0xdf,0x75,0xe9,0x0d,0x39,0x20,0x9b,0xd6,0x00,0xdc,0x8a,0xe5,0xc0,0xd0,0xea,0xab},
     /*TST_DSize*/
    128,
    /*TST_ExportedD*/
    {0},
    /*TST_ExportedDSize*/
    0
  },
  {
    {"RSA1024 key"},
    /*TST_KeyPwd*/
    {0x07,0x07,0x04,0x04,0x01,0x02,0x02,0x02,0x02,0x02},
    /*TST_KeyPwdLen*/
    10,
    /*TST_KeyType*/
    KMNG_KeyTypeRSAPair,
    /*TST_KeyUsage - not used*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction - not used*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_KeySize*/
    128,
    /*TST_E*/
    {0x01,0x00,0x01},
    /*TST_ESize*/
    3,
    /*TST_ExportedE*/
    {0},
    /*TST_ExportedESize*/
    0,
    /*TST_N*/
    {0xb7,0x33,0x08,0x1b,0x2d,0x70,0x31,0xd1,0xec,0x27,0x8b,0xb7,0x71,0x75,0x0e,0x63,
     0x97,0xef,0xd9,0x1f,0x36,0x49,0x36,0xb3,0x43,0xf4,0xbb,0x0a,0x9d,0x67,0xa8,0xc8,
     0x5a,0x1a,0x57,0xd5,0x5a,0x90,0x9e,0xed,0xad,0xc5,0x1d,0x0d,0x7a,0x66,0x30,0x61,
     0x6d,0xd2,0xef,0x6b,0xca,0xe2,0x21,0x09,0x9e,0xe4,0x2d,0xec,0x28,0x1e,0x27,0xbc,
     0xd3,0xf2,0xb3,0x01,0x44,0xc7,0x62,0x96,0xbe,0xf7,0x70,0x9e,0xdf,0xa3,0x02,0x3a,
     0x95,0x99,0x40,0x01,0x8c,0xf6,0xf6,0x88,0xe9,0xee,0x7d,0xea,0x51,0x1f,0x22,0xa5,
     0xd9,0xa7,0xfb,0x58,0x1d,0x77,0x21,0xc1,0x8e,0x0e,0xbc,0xd5,0xa0,0x87,0x99,0x36,
     0xcb,0x10,0xe8,0x08,0xf8,0x4d,0xd2,0xec,0xad,0x92,0x37,0x98,0x9a,0x32,0xdf,0x61},
    /*TST_NSize*/
    128,
    /*TST_ExportedN*/
    {0},
    /*TST_ExportedNSize*/
    0,
     /*TST_D*/
    {0xb6,0xdb,0xba,0x20,0x9e,0x77,0x19,0x53,0x46,0x9b,0xa6,0x6a,0xc1,0x55,0xac,0xba,
     0x1e,0x22,0xea,0x9e,0xab,0xe9,0xe2,0x2e,0x87,0x0b,0x15,0x53,0x20,0x10,0x22,0xb9,
     0x70,0xae,0x50,0xb3,0x86,0x05,0x4a,0x8d,0x44,0xe0,0xb6,0x02,0x09,0x05,0x4d,0x0f,
     0x42,0xb6,0xc4,0x01,0xdc,0xed,0x5f,0x3a,0xa2,0x1d,0x71,0xf5,0x01,0x8a,0x2f,0xf0,
     0x2b,0x6f,0x33,0x2e,0x68,0xa6,0x40,0xb0,0x3f,0x66,0x7c,0xd0,0xe6,0x70,0x79,0x54,
     0x58,0x35,0x66,0x04,0x71,0xf8,0xc0,0x93,0x4b,0xe9,0x06,0x3b,0xf8,0xf2,0xe2,0x77,
     0x36,0xe0,0xfe,0x42,0x43,0x3c,0x3a,0x01,0x10,0xd2,0x6f,0xc1,0xb8,0x93,0x6e,0x03,
     0x60,0xaa,0x37,0x51,0x57,0x9a,0x8c,0xa8,0x9e,0x1b,0x10,0xab,0x43,0x88,0x83,0x51},
    /*TST_DSize*/
    128,
    /*TST_ExportedD*/
    {0},
    /*TST_ExportedDSize*/
    0
  }  
}; 


TST_RingListDH_TestDataStruct TST_RingListDH_TestData[] = 
{
  {
    {"DH1024 key"},
    /*TST_KeyPwd*/
    {0xaa,0xaa,0xaa,0xaa},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyType*/
    KMNG_KeyTypeDH,
    /*TST_KeyUsage - not used*/
    KMNG_KEY_USAGE_LEGACY,
    /*TST_KeyRestriction - not used*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_P*/
    {0xf6,0x3f,0xeb,0x6d,0xa5,0x2c,0x0c,0xe3,0xd9,0x77,0xb0,0x6d,0xc5,0xc7,0x2b,0xa2,
     0x26,0x45,0xa4,0xc8,0x9c,0x95,0xcd,0x90,0xea,0x8d,0xff,0x2d,0x94,0xef,0x35,0x77,
     0xd2,0xac,0xa8,0x12,0x46,0x8f,0x4c,0xce,0x86,0x50,0x42,0xbd,0xfe,0xb2,0x1a,0x81,
     0x91,0x6e,0x4c,0x3b,0x9d,0x4a,0x87,0x15,0x3c,0xda,0xfe,0xa6,0x45,0xe9,0x61,0x28,
     0xad,0x5c,0xbf,0x8a,0x7b,0xd8,0x22,0x1e,0x59,0xc7,0x47,0xb9,0x4f,0xce,0xf9,0x4e,
     0x23,0x00,0x20,0x9c,0xc7,0xa9,0xab,0xde,0xc4,0x84,0x66,0xb9,0xbc,0x1a,0x8a,0x0e,
     0x60,0x25,0x1f,0x84,0xf1,0x0d,0x8d,0x81,0xa7,0x5a,0x07,0x72,0x73,0x15,0x49,0x41,
     0x14,0x43,0xd0,0x57,0x39,0x7d,0x89,0xe3,0x85,0xd1,0x48,0x2e,0x1c,0xec,0xe1,0x0b},
    /*TST_PSize*/
    128,
    /*TST_ExportedP*/
    {0},
    /*TST_ExportedPSize*/
    0,
     /*TST_G*/
    {0x05},
    /*TST_GSize*/
    1,    
    /*TST_ExportedG*/
    {0},
    /*TST_ExportedGSize*/
    0,
     /*TST_N*/
    {0x98,0x75,0x8e,0xbe,0xce,0xc8,0x60,0xa2,0x21,0x74,0xe9,0x1b,0x2b,0xd1,0xad,0x5e,
     0xad,0xa1,0x8a,0x1b,0x15,0x01,0x06,0xc5,0x93,0xbe,0x27,0x97,0x51,0x69,0xfa,0xc9,
     0xbe,0x5c,0xc8,0x8c,0xb3,0xa0,0x7f,0xa3,0x96,0x66,0x27,0xd5,0x28,0xc4,0x49,0x5a,
     0x09,0x0d,0xa2,0x12,0x6b,0xaa,0xe0,0x85,0x6a,0x3e,0x71,0xee,0x72,0xc0,0x05,0x9f,
     0x37,0x3d,0x37,0x8c,0x95,0x47,0x70,0x6c,0xef,0xc0,0x82,0x27,0xbe,0x25,0x96,0x75,
     0xdc,0x08,0x35,0x66,0x07,0xfe,0xa8,0x4e,0xf1,0x46,0x84,0xef,0x15,0x41,0x75,0x18,
     0x0e,0xb1,0xb8,0x6f,0xf4,0xce,0x04,0x19,0xba,0x21,0x37,0xbf,0x08,0xa5,0x2d,0x2b,
     0x22,0x4f,0xcf,0xe0,0x7c,0x6d,0xb5,0x0e,0xd4,0xc5,0x69,0x99,0xb2,0xb0,0x21,0x18},
    /*TST_NSize*/
    128,
    /*TST_ExportedN*/
    {0},
    /*TST_ExportedNSize*/
    0,
    /*TST_D*/
    {0x71,0x61,0xcd,0xa3,0x5b,0x5d,0xa0,0xf8,0xfd,0x7a,0x2d,0x06,0x1b,0x71,0xaa,0x74,
     0x15,0xc1,0x3f,0x78,0x00,0x78,0x65,0xc7,0x7b,0x81,0xb3,0x3f,0xf9,0xb2,0x09,0x78,
     0x5d,0xb1,0xdd,0x03,0x49,0xce,0x6d,0x8a,0x81,0x5a,0x58,0x9b,0xd9,0x5f,0x47,0xe2,
     0xff,0x8c,0xbe,0x5a,0x0c,0xa1,0xee,0xcb,0x5a,0xac,0x62,0xbe,0x66,0xd1,0xdd,0xce,
     0xed,0xa1,0x11,0xfd,0xc0,0xbb,0xfb,0xe8,0xcc,0xa8,0xfb,0x0f,0x0c,0x59,0x11,0x3e,
     0x5f,0x51,0x65,0x09,0x8b,0x68,0xdf,0x3a,0x4f,0x52,0xed,0xd0,0xec,0x18,0xc2,0x61,
     0xbd,0x3b,0xf7,0x55,0x4f,0xdf,0xc0,0xec,0x8e,0x0a,0x84,0x6a,0xf7,0xb3,0xf7,0x30,
     0x9e,0xdf,0xcf,0xc4,0x00,0xc4,0xdc,0x35,0x05,0x11,0x9d,0x7f,0xf4,0x73,0xa5,0x4a}, 
    /*TST_DSize*/
    128,
    /*TST_ExportedD*/
    {0},
    /*TST_ExportedDSize*/
    0
  },
  {
    {"DH1024 key"},
    /*TST_KeyPwd*/
    {0xb,0xc,0xd,0xe,0x1},
    /*TST_KeyPwdLen*/
    5,
    /*TST_KeyType*/
    KMNG_KeyTypeDH,
    /*TST_KeyUsage - not used*/
    KMNG_KEY_USAGE_LEGACY,
    /*TST_KeyRestriction - not used*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_P*/
    {0x89,0xd2,0x99,0x2a,0x52,0x05,0xd5,0x7b,0x71,0xe5,0x5b,0x5b,0xcc,0x4a,0xc8,0xff,
     0x43,0x47,0x8e,0x7d,0xf5,0xde,0x07,0x86,0x2f,0x5b,0x0c,0xf1,0xd1,0xf9,0x49,0x8a,
     0x5c,0x32,0x89,0x4b,0x08,0xa7,0x26,0x86,0x8f,0xfb,0x12,0x3d,0x24,0xec,0x55,0xdd,
     0xdf,0xa2,0xea,0x4a,0x61,0xe6,0x37,0x9a,0x67,0xb2,0x0d,0x85,0x74,0x2c,0x36,0xb6,
     0x0d,0x03,0xe5,0xf3,0x5c,0xb2,0x4e,0x25,0x70,0x05,0x63,0x23,0xd7,0x1d,0x63,0x23,
     0xb1,0x1d,0x58,0x4c,0x6a,0xa4,0xb8,0xa4,0x35,0x8a,0x51,0xd0,0x47,0xa6,0x92,0x60,
     0xd0,0xbd,0xcb,0xac,0xfa,0xf8,0x5c,0x50,0xdb,0x7f,0xf3,0x18,0xda,0x44,0x73,0xa2,
     0xce,0xab,0x95,0x59,0x40,0x3c,0xf9,0x35,0x31,0xac,0x6b,0x83,0xe0,0x87,0xb4,0x7b},
     /*TST_PSize*/
    128,
    /*TST_ExportedP*/
    {0},
    /*TST_ExportedPSize*/
    0,
     /*TST_G*/
    {0x02},
     /*TST_GSize*/
    1,
    /*TST_ExportedG*/
    {0},
    /*TST_ExportedGSize*/
    0,
     /*TST_N*/
    {0x4a,0x82,0x76,0xef,0x32,0x59,0x5b,0x31,0x4a,0xc3,0x38,0x14,0x86,0x00,0x57,0x82,
     0x97,0xcc,0x7a,0xe1,0x50,0x1a,0xc7,0x38,0xd4,0x59,0xc6,0x49,0xf1,0xa4,0x19,0x15,
     0xc4,0xdd,0x38,0x71,0x52,0x2d,0xb7,0xba,0xed,0xe2,0xbd,0x97,0x21,0x49,0xf3,0x70,
     0x3f,0x5c,0xcc,0x43,0x1b,0xe0,0xe7,0x0c,0x67,0xe1,0x61,0xef,0x9b,0x5c,0x48,0x2d,
     0x18,0xf0,0x41,0x62,0xe4,0x22,0x19,0x75,0x64,0xa3,0xff,0x36,0xdf,0x5e,0x89,0x0f,
     0x2b,0xa2,0x8d,0xb3,0x92,0x71,0x7e,0x09,0xce,0x6d,0xcc,0x7b,0x16,0x44,0x05,0x12,
     0xca,0x3b,0x1c,0x03,0xf0,0x16,0x44,0x34,0xcb,0x6e,0x34,0x0f,0x74,0x66,0x9e,0x38,
     0x91,0x10,0xc6,0xb8,0x16,0xd8,0x04,0x48,0x50,0x9e,0x82,0xcf,0x38,0x6d,0x07,0x01},
     /*TST_NSize*/
    128,
    /*TST_ExportedN*/
    {0},
    /*TST_ExportedNSize*/
    0,
    /*TST_D*/
    {0x69,0xb6,0x42,0x70,0x91,0x39,0xbe,0x65,0x40,0xf3,0xa0,0x26,0x0b,0x93,0x79,0x92,
     0x99,0xad,0x40,0xc4,0x26,0x49,0x5e,0x43,0x10,0x1a,0x8d,0xc3,0x27,0x4d,0xad,0xc0,
     0xce,0xe7,0x8b,0x2a,0x14,0x6d,0x9d,0xa3,0x74,0x8f,0x3a,0x6f,0x1e,0xf1,0x96,0x7e,
     0x5c,0x46,0x7e,0xd7,0x0f,0xd9,0x43,0x8a,0xee,0xb7,0x9d,0x71,0x98,0xd0,0x13,0x35,
     0x06,0x49,0x1c,0xf1,0xb2,0x81,0x2e,0x6e,0x1e,0xe9,0x25,0xf5,0x8a,0x61,0xf2,0x33,
     0x8d,0x3d,0xbe,0x0d,0x56,0x6d,0x3b,0x03,0x7e,0x85,0xb0,0xca,0x19,0x84,0x86,0xa9,
     0x17,0xaa,0xb8,0x69,0x9c,0x88,0xf5,0xf5,0x38,0xf6,0xee,0x66,0x85,0xce,0x2d,0x9a,
     0xf7,0xec,0x6a,0xe0,0x6d,0x2a,0xd4,0x2b,0x1d,0x9a,0x15,0x28,0x43,0x49,0x26,0x62}, 
    /*TST_DSize*/
    128,
    /*TST_ExportedD*/
    {0},
    /*TST_ExportedDSize*/
    0
  },
  {
    {"DH2048 key"},
    /*TST_KeyPwd*/
    {0xb,0xc,0xd,0xe,0xf},
    /*TST_KeyPwdLen*/
    5,
    /*TST_KeyType*/
    KMNG_KeyTypeDH,
    /*TST_KeyUsage - not used*/
    KMNG_KEY_USAGE_LEGACY,
    /*TST_KeyRestriction - not used*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_P*/
    {0xd7,0x6c,0xce,0x1b,0x98,0x35,0x80,0x89,0xa5,0x68,0xf8,0x7d,0x17,0x4b,0x52,0x34,
     0x60,0x3b,0xcf,0xe3,0x95,0xa8,0x5a,0xc7,0xbc,0x6f,0xf6,0xb4,0x8c,0x94,0x68,0x50,
     0x31,0x0a,0xa0,0x1c,0x86,0xd8,0xff,0x33,0x9b,0x51,0xf7,0xe4,0xf1,0x25,0x8c,0xeb,
     0x41,0xd9,0xbf,0x2d,0x79,0x52,0x62,0x77,0x07,0x47,0xd4,0x71,0xb8,0xce,0x9e,0xd8,
     0xeb,0x93,0xf9,0x32,0x60,0xcb,0x89,0x89,0x73,0x54,0xfa,0x92,0x55,0xf7,0x16,0x31,
     0xfe,0x97,0x4e,0xe0,0x83,0x0e,0xb1,0xcd,0x8f,0x7a,0xf6,0xef,0x21,0xe5,0x4f,0xe2,
     0xd5,0x0f,0x8b,0x0f,0x68,0xdf,0xff,0xab,0x46,0xf1,0x83,0x30,0x4d,0xab,0x0e,0x81,
     0x65,0x83,0xe9,0x40,0x58,0x6d,0x05,0x40,0x2e,0x2b,0x61,0x77,0x72,0x1e,0x9b,0x65,
     0xe6,0x19,0x0d,0xf0,0xae,0x2d,0x94,0x15,0xe5,0xb2,0x79,0xdb,0x0a,0x9c,0x5d,0x59,
     0x8d,0x0f,0xa7,0xf7,0x5e,0x96,0xf9,0xe8,0x2e,0x29,0x85,0xea,0x3b,0x36,0xa2,0xf9,
     0x2a,0x2e,0xdf,0xc3,0x5b,0x51,0xd0,0x21,0xa0,0xa1,0x9d,0x90,0xe3,0x55,0xfd,0xb9,
     0xfb,0x0e,0x5b,0xcc,0x22,0x9e,0x1a,0x6b,0xb6,0x4d,0x3d,0x2f,0x33,0x91,0x06,0xfd,
     0x36,0xbb,0x8b,0xd8,0x78,0x15,0xf3,0x80,0x45,0x2f,0x6d,0xa5,0xb6,0xe7,0x27,0xc8,
     0x59,0xea,0xe0,0x12,0x65,0x9f,0x6a,0xb6,0xf2,0x99,0x86,0x05,0xba,0x6d,0xf5,0x64,
     0x58,0x39,0xcb,0x67,0x61,0x6f,0x8a,0x76,0xe7,0x0e,0x26,0xcd,0x1f,0x63,0x36,0x60,
     0x6c,0x7d,0x26,0x03,0xc8,0x07,0x5e,0x3a,0x7a,0x84,0x0b,0x1b,0x44,0xd4,0xf4,0xb3},
     /*TST_PSize*/
    256,
    /*TST_ExportedP*/
    {0},
    /*TST_ExportedPSize*/
    0,
     /*TST_G*/
    {0x02},
     /*TST_GSize*/
    1,
    /*TST_ExportedG*/
    {0},
    /*TST_ExportedGSize*/
    0,
     /*TST_N*/
    {0xa1,0xe0,0x88,0xa9,0xd9,0x4c,0x9b,0x71,0x7f,0xd9,0x6a,0x4c,0xab,0x4c,0xa8,0xf7,
     0x0c,0x3e,0xf4,0x48,0x16,0x69,0x66,0x00,0x1f,0xbd,0x04,0xae,0xd6,0x13,0x71,0xed,
     0xd5,0xbd,0x4c,0x54,0xa7,0xe8,0x0a,0x15,0x83,0x0c,0xb8,0x27,0xea,0x75,0x3b,0x72,
     0x6e,0xba,0x9b,0x06,0x29,0xc7,0x8f,0xbc,0xc3,0xa4,0x98,0x0a,0x12,0x8b,0x0d,0x1a,
     0xe8,0x00,0x46,0x4f,0x59,0x3e,0xc9,0x55,0xb4,0x8a,0xee,0x10,0xa4,0x54,0x2a,0xaf,
     0x9c,0x0d,0x1d,0x1b,0xb5,0xef,0x42,0x92,0x7f,0x88,0xea,0x33,0x85,0x0a,0x64,0x78,
     0xce,0xb1,0x13,0x9a,0x12,0x21,0xa9,0x27,0x10,0xbf,0x6d,0xf1,0xf6,0x13,0x9f,0x79,
     0x35,0x62,0xa4,0xfe,0x21,0x1a,0x8e,0xb5,0x45,0xd4,0xb5,0x36,0x23,0x9b,0xca,0x89,
     0xf1,0x24,0x2a,0x0e,0x55,0xf8,0x59,0xcb,0xe1,0x56,0xe2,0xb4,0x83,0xe0,0xc9,0x2a,
     0x1d,0xc5,0xb1,0x53,0xb7,0x57,0xf1,0x17,0x5d,0xc1,0xce,0xc6,0x52,0xe4,0xac,0x10,
     0xe0,0xa8,0xae,0x33,0xa1,0x82,0xde,0xd6,0x8a,0x64,0x79,0x81,0xab,0x37,0xb3,0x62,
     0x62,0x9a,0x29,0xca,0x86,0xd3,0x57,0xa7,0xdb,0xd5,0x34,0x54,0x5f,0x35,0x85,0xa5,
     0x3f,0xa1,0x54,0x32,0x54,0x1b,0x88,0xda,0x07,0x91,0xdb,0x13,0xaf,0xc4,0xcd,0x92,
     0x7c,0x5a,0x31,0xf6,0x10,0xac,0x66,0x99,0x17,0x14,0x1a,0xe8,0x1c,0x41,0x96,0x70,
     0xfc,0xa8,0x5d,0xf0,0xad,0x1c,0xa0,0xce,0xc5,0xe6,0xe8,0xea,0xb4,0x4f,0xfe,0x45,
     0x29,0x86,0x0f,0xa1,0x1f,0x46,0x0d,0x47,0x76,0xba,0x21,0xe3,0xd1,0x76,0xc0,0xa6},
     /*TST_NSize*/
    256,
    /*TST_ExportedN*/
    {0},
    /*TST_ExportedNSize*/
    0,
    /*TST_D*/
    {0x42,0x2e,0xb5,0x8b,0x74,0x05,0x43,0x39,0xf2,0xf0,0x94,0x5f,0x70,0x20,0x29,0xe5,
     0x29,0x32,0x73,0x53,0x4f,0xbf,0xc9,0xbd,0x9b,0xae,0x2f,0x7b,0xca,0x05,0x95,0xaa,
     0x70,0x2c,0xa0,0x36,0x8a,0x27,0x1e,0x99,0xc0,0xfa,0xb3,0xef,0x44,0xa3,0x1b,0x60,
     0xbf,0x89,0xa8,0x6c,0x50,0x0b,0xa7,0x31,0x50,0xd2,0x11,0x04,0xf5,0x00,0xa1,0x59,
     0xf1,0xa1,0x3e,0x24,0x08,0x66,0xea,0xcb,0x31,0x08,0xec,0x52,0x4e,0x58,0xc0,0x68,
     0x45,0x3d,0x22,0x0a,0x14,0xea,0x0f,0xb0,0x2b,0x7f,0x46,0xf6,0xd4,0xff,0xfc,0xda,
     0x05,0xec,0x6a,0xb1,0x24,0x5e,0x06,0x6e,0x7d,0x5d,0xf1,0x21,0x53,0x25,0xe6,0x58,
     0x12,0xc6,0x2f,0x09,0x96,0x20,0xdb,0xf7,0x78,0x03,0x9b,0xf2,0xb2,0x80,0x23,0xce,
     0x4a,0xcb,0x6c,0xa1,0xdd,0x81,0xc5,0x30,0x01,0x3f,0x0a,0xdc,0x0a,0x47,0x61,0x3f,
     0xb2,0x88,0xb5,0xc6,0xd4,0x8e,0x45,0xad,0xab,0x79,0x8b,0x45,0x62,0x47,0xb5,0xee,
     0xa0,0x3c,0x40,0xa4,0x51,0x43,0x96,0x8f,0x02,0x0d,0x45,0x84,0xc6,0xa9,0x5d,0x68,
     0x2b,0xd5,0x03,0xc8,0xb4,0xd3,0x87,0x48,0xbf,0x12,0x9e,0x83,0xde,0xc8,0x83,0x70,
     0x33,0xea,0x2b,0xe2,0xcc,0x5b,0x01,0x52,0x67,0xfa,0x7e,0x53,0xa3,0xbe,0x2c,0x1a,
     0xe0,0x70,0x2b,0xda,0x5b,0x72,0x45,0xf3,0x5b,0x58,0x96,0x39,0xfd,0x7a,0xa7,0xf0,
     0xfd,0x4a,0x6c,0xd4,0x58,0x0a,0x73,0x0b,0x98,0x46,0x55,0xbd,0x0d,0x78,0x90,0xb3,
     0x1a,0xd6,0xff,0x8f,0x52,0x73,0xd6,0xa9,0x13,0x91,0x3e,0xf8,0x72,0x3e,0xb3,0x4e}, 
     /*TST_DSize*/
    256,
    /*TST_ExportedD*/
    {0},
    /*TST_ExportedDSize*/
    0, 
  }
};

TST_KeysSym_TestDataStruct TST_TwoRingsSymKey_TestData[] = 
{
  {
   // {"Acceptance test - Key Ring Management 2 rings imported 128AES key"},
	{"128AES key"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08},
    /*TST_KeySize*/
    16,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x1a,0xd6,0xff,0x8f,0x52,0x73,0xd6,0xa9,0x13,0x91,0x3e,0xf8,0x72,0x3e,0xb3,0x4e},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0xdd,0xd3,0x44,0x6f,0xf2,0x86,0x42,0xaa,0x3c,0xa7,0x64,0xbc,0xe7,0x48,0x06,0xb5},
    /* TST_Output*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_VERIFY_OUTPUT,
    /* TST_UserData*/
    {0}
  },
  {
    {"64HMAC key"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeHMAC,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0xce,0xb1,0x13,0x9a,0x12,0x21,0xa9,0x27,0x10,0xbf,0x6d,0xf1,0xf6,0x13,0x9f,0x79,
     0x35,0x62,0xa4,0xfe,0x21,0x1a,0x8e,0xb5,0x45,0xd4,0xb5,0x36,0x23,0x9b,0xca,0x89,
     0xf1,0x24,0x2a,0x0e,0x55,0xf8,0x59,0xcb,0xe1,0x56,0xe2,0xb4,0x83,0xe0,0xc9,0x2a,
     0x1d,0xc5,0xb1,0x53,0xb7,0x57,0xf1,0x17,0x5d,0xc1,0xce,0xc6,0x52,0xe4,0xac,0x10},
     /*TST_KeySize*/
     64,
     /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA512_mode,
    /*TST_Data*/
    {0x1a,0xd6,0xff,0x8f,0x52,0x73,0xd6,0xa9,0x13,0x91,0x3e,0xf8,0x72,0x3e,0xb3,0x4e},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0xf7,0xf4,0x1f,0x5a,0x17,0x08,0x9a,0x3e,0x83,0x4c,0x4b,0xda,0xaf,0xee,0x93,0xe8,
     0x70,0x87,0x72,0x9b,0x9b,0xd5,0x93,0xf5,0xbe,0x63,0x43,0xdc,0x16,0x69,0x5f,0xf4,
     0x99,0x27,0x8b,0xeb,0xcf,0x30,0x69,0x10,0x7d,0x43,0xee,0xb0,0xab,0xd2,0x17,0xe9,
     0xb6,0x5b,0x67,0x07,0xa2,0xb9,0x7b,0xc3,0x37,0xf6,0x63,0x75,0x15,0x66,0x54,0xab},
     /* TST_Output*/
    {0},
    /*TST_OutputLen*/
    64,
    TST_KMNG_VERIFY_OUTPUT,
    /* TST_UserData*/
    {0}
  },
  {
    {"128AES key"},
    /*TST_Pwd*/
    {0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    16,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0x1a,0xd6,0xff,0x8f,0x52,0x73,0xd6,0xa9,0x13,0x91,0x3e,0xf8,0x72,0x3e,0xb3,0x4e},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0xdd,0xd3,0x44,0x6f,0xf2,0x86,0x42,0xaa,0x3c,0xa7,0x64,0xbc,0xe7,0x48,0x06,0xb5},
    /* TST_Output*/
    {0},
    /*TST_OutputLen*/
    16,
    TST_KMNG_VERIFY_OUTPUT,
    /* TST_UserData*/
    {0}
  },
  {
    {"64HMAC key"},
    /*TST_Pwd*/
    {0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeHMAC,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0},
    /*TST_KeySize*/
    64,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA512_mode,
    /*TST_Data*/
    {0x1a,0xd6,0xff,0x8f,0x52,0x73,0xd6,0xa9,0x13,0x91,0x3e,0xf8,0x72,0x3e,0xb3,0x4e},
    /*TST_DataLen*/
    16,
    /*TST_ExpectedOutput*/
    {0xf7,0xf4,0x1f,0x5a,0x17,0x08,0x9a,0x3e,0x83,0x4c,0x4b,0xda,0xaf,0xee,0x93,0xe8,
     0x70,0x87,0x72,0x9b,0x9b,0xd5,0x93,0xf5,0xbe,0x63,0x43,0xdc,0x16,0x69,0x5f,0xf4,
     0x99,0x27,0x8b,0xeb,0xcf,0x30,0x69,0x10,0x7d,0x43,0xee,0xb0,0xab,0xd2,0x17,0xe9,
     0xb6,0x5b,0x67,0x07,0xa2,0xb9,0x7b,0xc3,0x37,0xf6,0x63,0x75,0x15,0x66,0x54,0xab},
     /* TST_Output*/
    {0},
    /*TST_OutputLen*/
    64,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  }
};


TST_KeysRSA_TestDataStruct TST_TwoRingsRSAKey_TestData[] = 
{
  {
    {"1024RSA key"},
    /*TST_Pwd*/
    {0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeRSAPair,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_KeySize*/
    128,
    /*TST_PKCS1_ver*/
    CRYS_PKCS1_VER15,
    /*TST_HASHMode*/
    CRYS_RSA_HASH_SHA1_mode,
    /*TST_E*/
    {0x01,0x00,0x01},
    /*TST_ESize*/
    3,
    /*TST_ExportedE*/
    {0},
    /*TST_ExportedESize*/
    0,    
    /*TST_N*/
    {0xb7,0x33,0x08,0x1b,0x2d,0x70,0x31,0xd1,0xec,0x27,0x8b,0xb7,0x71,0x75,0x0e,0x63,
     0x97,0xef,0xd9,0x1f,0x36,0x49,0x36,0xb3,0x43,0xf4,0xbb,0x0a,0x9d,0x67,0xa8,0xc8,
     0x5a,0x1a,0x57,0xd5,0x5a,0x90,0x9e,0xed,0xad,0xc5,0x1d,0x0d,0x7a,0x66,0x30,0x61,
     0x6d,0xd2,0xef,0x6b,0xca,0xe2,0x21,0x09,0x9e,0xe4,0x2d,0xec,0x28,0x1e,0x27,0xbc,
     0xd3,0xf2,0xb3,0x01,0x44,0xc7,0x62,0x96,0xbe,0xf7,0x70,0x9e,0xdf,0xa3,0x02,0x3a,
     0x95,0x99,0x40,0x01,0x8c,0xf6,0xf6,0x88,0xe9,0xee,0x7d,0xea,0x51,0x1f,0x22,0xa5,
     0xd9,0xa7,0xfb,0x58,0x1d,0x77,0x21,0xc1,0x8e,0x0e,0xbc,0xd5,0xa0,0x87,0x99,0x36,
     0xcb,0x10,0xe8,0x08,0xf8,0x4d,0xd2,0xec,0xad,0x92,0x37,0x98,0x9a,0x32,0xdf,0x61},
    /*TST_NSize*/
    128,
    /*TST_ExportedN*/
    {0},
    /*TST_ExportedNSize*/
    0,    
     /*TST_D*/
    {0xb6,0xdb,0xba,0x20,0x9e,0x77,0x19,0x53,0x46,0x9b,0xa6,0x6a,0xc1,0x55,0xac,0xba,
     0x1e,0x22,0xea,0x9e,0xab,0xe9,0xe2,0x2e,0x87,0x0b,0x15,0x53,0x20,0x10,0x22,0xb9,
     0x70,0xae,0x50,0xb3,0x86,0x05,0x4a,0x8d,0x44,0xe0,0xb6,0x02,0x09,0x05,0x4d,0x0f,
     0x42,0xb6,0xc4,0x01,0xdc,0xed,0x5f,0x3a,0xa2,0x1d,0x71,0xf5,0x01,0x8a,0x2f,0xf0,
     0x2b,0x6f,0x33,0x2e,0x68,0xa6,0x40,0xb0,0x3f,0x66,0x7c,0xd0,0xe6,0x70,0x79,0x54,
     0x58,0x35,0x66,0x04,0x71,0xf8,0xc0,0x93,0x4b,0xe9,0x06,0x3b,0xf8,0xf2,0xe2,0x77,
     0x36,0xe0,0xfe,0x42,0x43,0x3c,0x3a,0x01,0x10,0xd2,0x6f,0xc1,0xb8,0x93,0x6e,0x03,
     0x60,0xaa,0x37,0x51,0x57,0x9a,0x8c,0xa8,0x9e,0x1b,0x10,0xab,0x43,0x88,0x83,0x51},
    /*TST_DSize*/
    128,
    /*TST_ExportedD*/
    {0},
    /*TST_ExportedDSize*/
    0,
    /*TST_Data*/
    {0x42,0x2e,0xb5,0x8b,0x74,0x05,0x43,0x39,0xf2,0xf0,0x94,0x5f,0x70,0x20,0x29,0xe5,
     0x29,0x32,0x73,0x53,0x4f,0xbf,0xc9,0xbd,0x9b,0xae,0x2f,0x7b,0xca,0x05,0x95,0xaa,
     0x70,0x2c,0xa0,0x36,0x8a,0x27,0x1e,0x99,0xc0,0xfa,0xb3,0xef,0x44,0xa3,0x1b,0x60,
     0xbf,0x89,0xa8,0x6c,0x50,0x0b,0xa7,0x31,0x50,0xd2,0x11,0x04,0xf5,0x00,0xa1,0x59,
     0xf1,0xa1,0x3e,0x24,0x08,0x66,0xea,0xcb,0x31,0x08,0xec,0x52,0x4e,0x58,0xc0,0x68,
     0x45,0x3d,0x22,0x0a,0x14,0xea,0x0f,0xb0,0x2b,0x7f,0x46,0xf6,0xd4,0xff,0xfc,0xda,
     0x05,0xec,0x6a,0xb1,0x24,0x5e,0x06,0x6e,0x7d,0x5d,0xf1,0x21,0x53,0x25,0xe6,0x58,
     0x12,0xc6,0x2f,0x09,0x96,0x20,0xdb,0xf7,0x78,0x03,0x9b,0xf2,0xb2,0x80,0x23,0xce},
    /*TST_DataLen*/
    128,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputLen*/
    0,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"1024RSA key"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeRSAPair,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_KeySize*/
    128,
    /*TST_PKCS1_ver*/
    CRYS_PKCS1_VER21,
    /*TST_HASHMode*/
    CRYS_RSA_HASH_SHA1_mode,
    /*TST_E*/
    {0},
    /*TST_ESize*/
    0,
    /*TST_ExportedE*/
    {0},
    /*TST_ExportedESize*/
    0,    
    /*TST_N*/
    {0},
    /*TST_NSize*/
    0,
    /*TST_ExportedN*/
    {0},
    /*TST_ExportedNSize*/
    0,    
     /*TST_D*/
    {0},
    /*TST_DSize*/
    0,
    /*TST_ExportedD*/
    {0},
    /*TST_ExportedDSize*/
    0,
    /*TST_Data*/
    {0x42,0x2e,0xb5,0x8b,0x74,0x05,0x43,0x39,0xf2,0xf0,0x94,0x5f,0x70,0x20,0x29,0xe5,
     0x29,0x32,0x73,0x53,0x4f,0xbf,0xc9,0xbd,0x9b,0xae,0x2f,0x7b,0xca,0x05,0x95,0xaa,
     0x70,0x2c,0xa0,0x36,0x8a,0x27,0x1e,0x99,0xc0,0xfa,0xb3,0xef,0x44,0xa3,0x1b,0x60,
     0xbf,0x89,0xa8,0x6c,0x50,0x0b,0xa7,0x31,0x50,0xd2,0x11,0x04,0xf5,0x00,0xa1,0x59,
     0xf1,0xa1,0x3e,0x24,0x08,0x66,0xea,0xcb,0x31,0x08,0xec,0x52,0x4e,0x58,0xc0,0x68,
     0x45,0x3d,0x22,0x0a,0x14,0xea,0x0f,0xb0,0x2b,0x7f,0x46,0xf6,0xd4,0xff,0xfc,0xda,
     0x05,0xec,0x6a,0xb1,0x24,0x5e,0x06,0x6e,0x7d,0x5d,0xf1,0x21,0x53,0x25,0xe6,0x58,
     0x12,0xc6,0x2f,0x09,0x96,0x20,0xdb,0xf7,0x78,0x03,0x9b,0xf2,0xb2,0x80,0x23,0xce},
    /*TST_DataLen*/
    128,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputLen*/
    0,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  },
  {
    {"1024RSA key"},
    /*TST_Pwd*/
    {0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeRSAPair,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_KeySize*/
    128,
    /*TST_PKCS1_ver*/
    CRYS_PKCS1_VER21,
    /*TST_HASHMode*/
    CRYS_RSA_HASH_SHA1_mode,
    /*TST_E*/
    {0},
    /*TST_ESize*/
    0,
    /*TST_ExportedE*/
    {0},
    /*TST_ExportedESize*/
    0,    
    /*TST_N*/
    {0},
    /*TST_NSize*/
    0,
    /*TST_ExportedN*/
    {0},
    /*TST_ExportedNSize*/
    0,    
     /*TST_D*/
    {0},
    /*TST_DSize*/
    0,
    /*TST_ExportedD*/
    {0},
    /*TST_ExportedDSize*/
    0,
    /*TST_Data*/
    {0x42,0x2e,0xb5,0x8b,0x74,0x05,0x43,0x39,0xf2,0xf0,0x94,0x5f,0x70,0x20,0x29,0xe5,
     0x29,0x32,0x73,0x53,0x4f,0xbf,0xc9,0xbd,0x9b,0xae,0x2f,0x7b,0xca,0x05,0x95,0xaa,
     0x70,0x2c,0xa0,0x36,0x8a,0x27,0x1e,0x99,0xc0,0xfa,0xb3,0xef,0x44,0xa3,0x1b,0x60,
     0xbf,0x89,0xa8,0x6c,0x50,0x0b,0xa7,0x31,0x50,0xd2,0x11,0x04,0xf5,0x00,0xa1,0x59,
     0xf1,0xa1,0x3e,0x24,0x08,0x66,0xea,0xcb,0x31,0x08,0xec,0x52,0x4e,0x58,0xc0,0x68,
     0x45,0x3d,0x22,0x0a,0x14,0xea,0x0f,0xb0,0x2b,0x7f,0x46,0xf6,0xd4,0xff,0xfc,0xda,
     0x05,0xec,0x6a,0xb1,0x24,0x5e,0x06,0x6e,0x7d,0x5d,0xf1,0x21,0x53,0x25,0xe6,0x58,
     0x12,0xc6,0x2f,0x09,0x96,0x20,0xdb,0xf7,0x78,0x03,0x9b,0xf2,0xb2,0x80,0x23,0xce},
    /*TST_DataLen*/
    128,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputLen*/
    0,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0}
  }
};

TST_KeysSym_TestDataStruct TST_KeysSymData_TestData[] = 
{
  {
    {"128AES key ECB"},
    /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeAES,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_STORAGE,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_key*/
    {0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08},
    /*TST_KeySize*/
    16,
    /*TST_Exportedkey*/
    {0},
    /*TST_IV*/
    {0},
    /*TST_AESMode*/
    CRYS_AES_ECB_mode,
    /*TST_DESMode*/
    CRYS_DES_ECB_mode,
    /*TST_HASHMode*/
    CRYS_HASH_SHA1_mode,
    /*TST_Data*/
    {0},
    /*TST_DataLen*/
    0,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_Output*/
    {0},
    /*TST_OutputLen*/
    0,
    TST_KMNG_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0x1234, 0x5678}
  }
};

TST_KeysRSA_TestDataStruct TST_KeysRSAData_TestData[] = 
{
  {
    {"1024RSA PKCS1v15 key"},
      /*TST_Pwd*/
    {0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf,0xf},
    /*TST_PwdLen*/
    10,
    /*TST_KeyPwd*/
    {0x1,0x2,0x3,0x4},
    /*TST_KeyPwdLen*/
    4,
    /*TST_KeyID*/
    0,
    /*TST_KeyType*/
    KMNG_KeyTypeRSAPair,
    /*TST_KeyUsage*/
    KMNG_KEY_USAGE_SIGNING,
    /*TST_KeyRestriction*/
    KMNG_KEY_RESTRICTION_EXPORTABLE,
    /*TST_KeySize*/
    128,
    /*TST_PKCS1_ver*/
    CRYS_PKCS1_VER15,
    /*TST_HASHMode*/
    CRYS_RSA_HASH_SHA1_mode,
    /*TST_E*/
    {0x01,0x00,0x01},
    /*TST_ESize*/
    3,
    /*TST_ExportedE*/
    {0},
    /*TST_ExportedESize*/
    0,    
    /*TST_N*/
    {0},
    /*TST_NSize*/
    128,
    /*TST_ExportedN*/
    {0},
    /*TST_ExportedNSize*/
    0,    
    /*TST_D*/
    {0},
    /*TST_DSize*/
    128,
    /*TST_ExportedD*/
    {0},
    /*TST_ExportedDSize*/
    0,
    /*TST_Data*/
    {0},
    /*TST_DataLen*/
    128,
    /*TST_ExpectedOutput*/
    {0},
    /*TST_OutputLen*/
    0,
    TST_KMNG_DO_NOT_VERIFY_OUTPUT,
    /*TST_UserData*/
    {0x9876, 0x5432}
  }
};


const DxUint32_t TST_NumOf_ManageOpTests = sizeof(TST_RingManage_TestData)/sizeof(TST_RingManage_TestData[0]);
const DxUint32_t TST_NumOf_SymListTests = sizeof(TST_RingListSym_TestData)/sizeof(TST_RingListSym_TestData[0]);
const DxUint32_t TST_NumOf_RSAListTests = sizeof(TST_RingListRSA_TestData)/sizeof(TST_RingListRSA_TestData[0]);
const DxUint32_t TST_NumOf_DHListTests = sizeof(TST_RingListDH_TestData)/sizeof(TST_RingListDH_TestData[0]);
const DxUint32_t TST_NumOf_KeysRSADataTests = sizeof(TST_KeysRSAData_TestData)/sizeof(TST_KeysRSAData_TestData[0]);
const DxUint32_t TST_NumOf_KeysSymDataTests = sizeof(TST_KeysSymData_TestData)/sizeof(TST_KeysSymData_TestData[0]);
/************* Private function prototype ***********************/
/************************ Public Functions ******************************/
